
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
time_periods = ["Q1", "Q2", "Q3", "Q4"]  # Update for categorical x-axis
energy_consumption = [200, 180, 150, 130]
energy_savings = [20, 35, 45, 60]
green_energy_consumption = [150, 130, 100, 80]
green_energy_savings = [30, 50, 60, 75]

# Axes Limits and Labels
xticks_values = range(len(time_periods))
ylabel_value = "Energy (kWh) and Savings (%)"
xlabel_value = "Time Periods"

# Labels
label_1 = "Traditional Energy"
label_2 = "Green Energy"

# Titles
title_1 = "Energy Consumption and Savings (Traditional)"
title_2 = "Energy Consumption and Savings (Green)"

# Texts
text_1 = "25.0%"
text_2 = "37.5%"

labels = ["Energy Savings (%)", "Green Energy Savings (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Plotting for Traditional Energy
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    time_periods,
    energy_consumption,
    marker="s",
    color="#1f77b4",
    label=label_1,
    linewidth=2,
    markersize=6,
)
ax1.plot(
    time_periods,
    energy_savings,
    marker="^",
    linestyle="--",
    color="#ff7f0e",
    label=labels[0],
    linewidth=2,
    markersize=6,
)
ax1.set_title(title_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=14)  
ax1.legend(loc="best", fontsize=12)
ax1.set_xticklabels(time_periods, fontsize=12)  
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    "",
    xy=(0, energy_savings[0]),
    xytext=(0, energy_consumption[0]),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax1.text(
    0.1,
    (energy_consumption[0] + energy_savings[0]) / 2,
    text_1,
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Plotting for Green Energy
ax2.plot(
    time_periods,
    green_energy_consumption,
    marker="s",
    color="#2ca02c",
    label=label_2,
    linewidth=2,
    markersize=6,
)
ax2.plot(
    time_periods,
    green_energy_savings,
    marker="^",
    linestyle="--",
    color="#d62728",
    label=labels[1],
    linewidth=2,
    markersize=6,
)
ax2.set_title(title_2, fontsize=16)  
ax2.legend(loc="best", fontsize=12)
ax2.set_xticklabels(time_periods, fontsize=12)  
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    "",
    xy=(0, green_energy_savings[0]),
    xytext=(0, green_energy_consumption[0]),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax2.text(
    0.1,
    (green_energy_consumption[0] + green_energy_savings[0]) / 2,
    text_2,
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Common x-axis label
fig.text(0.5, 0.04, xlabel_value, ha='center', fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for resolution
plt.tight_layout()
plt.savefig("line_82.pdf", bbox_inches="tight")
