
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for Quarterly Economic Growth Rates over 10 years (40 quarters)
quarters = np.arange(1, 41, 1)
growth_baseline = np.random.normal(0.02, 0.01, 40)  # Baseline projection
growth_optimistic = growth_baseline + np.random.normal(0.01, 0.005, 40)  # Optimistic scenario
growth_pessimistic = growth_baseline - np.random.normal(0.01, 0.005, 40)  # Pessimistic scenario

# Labels and Plot Types
label_baseline = "Baseline Projection"
label_optimistic = "Optimistic Scenario"
label_pessimistic = "Pessimistic Scenario"

# Axes Limits and Labels
xlabel_value = "Quarters"
ylabel_value = "Economic Growth Rate (%)"
xlim_values = [0, 41]
ylim_values = [-0.02, 0.08]
xticks_values = np.arange(1, 41, 5)
yticks_values = np.arange(-0.02, 0.09, 0.01)
title="Quarterly Economic Growth Rate Projections"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    quarters, growth_baseline, "o-", label=label_baseline, color="#2E8B57", linewidth=2, markersize=5
)
plt.plot(
    quarters, growth_optimistic, "s-", label=label_optimistic, color="#1E90FF", linewidth=2, markersize=5
)
plt.plot(
    quarters, growth_pessimistic, "D-", label=label_pessimistic, color="#FF6347", linewidth=2, markersize=5
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18, pad=20)

# Adjusting x and y axis limits
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Setting x and y ticks
plt.xticks(xticks_values)  # X-axis from 1 to 40 with a step of 5
plt.yticks(yticks_values)  # Y-axis from -0.02 to 0.08 with a step of 0.01

# Adding legend outside the plot area
plt.legend(loc="upper left", bbox_to_anchor=(1, 1), fancybox=True, shadow=True)

# Adding semi-transparent grid
plt.grid(True, which="both", linewidth=0.5, alpha=0.3)  # Semi-transparent grid

# Removing top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_83.pdf", bbox_inches="tight")
