
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = np.array([1, 2, 3, 4, 5, 6])
strategy_A = np.array([0.1, 0.2, 0.35, 0.55, 0.75, 1.0])
strategy_B = np.array([0.05, 0.1, 0.18, 0.27, 0.4, 0.55])

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Return on Investment (ROI)"

ylim_values = [1e-2, 1e0]
yticks_values = [10**-2, 10**-1, 10**0]
yticks_labels = ["$10^{-2}$", "$10^{-1}$", "$10^0$"]

# Labels
label_Strategy_A = "Strategy A"
label_Strategy_B = "Strategy B"

# Title
title_value = "Comparison of Investment Strategies Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data
plt.loglog(
    years,
    strategy_A,
    "o-",
    color="#2ca02c",
    label=label_Strategy_A,
    markerfacecolor="#2ca02c",
    markersize=6,
    linestyle='--'
)  # Dashed line for Strategy A
plt.loglog(
    years, 
    strategy_B, 
    "x-", 
    color="#d62728", 
    label=label_Strategy_B, 
    markersize=6,
    linestyle='-'
)  # Solid line for Strategy B

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values)  # Extend y-axis to leave some space above 10^0

# Explicitly set the tick params for the x-axis
plt.tick_params(axis="x", labelsize=14)  # Ensure x-axis tick labels are of font size 14

# Add legend with transparent background
plt.legend(frameon=True, fontsize=12)

# Add a vertical line at x=1 and enable horizontal grid lines for structure
plt.axvline(x=1, color="grey", linestyle="--", linewidth=1)
plt.grid(
    True, which="both", ls="--", color="grey", linewidth=1, axis="y"
)  # Horizontal grid lines

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("line_86.pdf", bbox_inches="tight")
