
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
time_weeks = np.array([1, 2, 4, 8, 12, 16])
treatment_a = np.array([0.9, 0.8, 0.6, 0.5, 0.3, 0.2])
treatment_b = np.array([0.85, 0.75, 0.65, 0.55, 0.45, 0.4])

# Axes Limits and Labels
xlabel_value = "Time (Weeks)"
ylabel_value = "Effectiveness"

ylim_values = [0.1, 1]
yticks_values = [0.1, 0.2, 0.4, 0.6, 0.8, 1]
yticks_labels = ["10%", "20%", "40%", "60%", "80%", "100%"]

# Labels
label_TreatmentA = "Treatment A"
label_TreatmentB = "Treatment B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(9, 6))

# Plot the data
plt.semilogx(
    time_weeks,
    treatment_a,
    "o-",
    color="#2ca02c",  # Green color
    label=label_TreatmentA,
    markerfacecolor="#2ca02c",
    markersize=6,
    linewidth=2,
)  
plt.semilogx(
    time_weeks,
    treatment_b,
    "s--",
    color="#d62728",  # Red color
    label=label_TreatmentB,
    markerfacecolor="#d62728",
    markersize=6,
    linewidth=2,
)

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values) 

# Explicitly set the tick params for the x-axis
plt.tick_params(axis="x", labelsize=14)

# Add legend with transparent background
plt.legend(frameon=True, fontsize=14)

# Add a vertical line at x=1 and enable horizontal grid lines for structure
plt.axvline(x=1, color="grey", linestyle="--", linewidth=1)
plt.grid(
    True, which="both", ls="--", color="grey", linewidth=1, axis="both"
)  # Grid lines on both x and y axis

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("line_87.pdf", bbox_inches="tight")
