
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
time_intervals = np.array([1, 2, 3, 4, 5, 6])
regular_temp = np.random.uniform(15, 25, len(time_intervals))  # Regular temperature data
constrained_temp = np.random.uniform(15, 15.5, len(time_intervals))  # Constrained temperature data

# Axes Limits and Labels
xlabel_value = "Time (Months)"
ylabel_value = "Temperature (°C)"

ylim_values = [10, 30]
yticks_values = [10, 15, 20, 25, 30]
yticks_labels = ["10°C", "15°C", "20°C", "25°C", "30°C"]

# Labels
label_Regular = "Regular Measurement"
label_Constrained = "Constrained Measurement"
chart_title = "Temperature Change Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data
plt.plot(
    time_intervals,
    regular_temp,
    "o-",
    color="#008080",  # Teal color for Regular
    label=label_Regular,
    markerfacecolor="#008080",
    markersize=6,
    linewidth=2
)
plt.plot(
    time_intervals,
    constrained_temp,
    "s--",
    color="#FF7F50",  # Coral color for Constrained
    label=label_Constrained,
    markerfacecolor="#FF7F50",
    markersize=6,
    linewidth=2
)

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Add title
plt.title(chart_title, fontsize=16)

# Set y-axis ticks and labels
plt.yticks(yticks_values, yticks_labels)
plt.ylim(ylim_values)

# Adjust the tick params for both axes
plt.tick_params(axis="both", labelsize=12)

# Add legend with transparent background
plt.legend(frameon=True, fontsize=12)

# Add grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout for a better fit
plt.tight_layout()
plt.savefig("line_88.pdf", bbox_inches="tight")

