
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data: Monthly average temperatures (in °C) for four different cities
months = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
city1_avg = np.array([0, 2, 5, 9, 15, 18, 20, 19, 14, 9, 4, 1])
city1_err = np.array([1, 1.5, 1, 0.5, 1, 1.5, 2, 1.5, 1, 0.5, 1, 1])

city2_avg = np.array([5, 6, 9, 12, 17, 20, 22, 21, 18, 13, 9, 6])
city2_err = np.array([1.2, 1.3, 1.4, 1.2, 1.3, 1.1, 1.2, 1.1, 1.3, 1.2, 1.3, 1.2])

city3_avg = np.array([-3, -2, 1, 4, 9, 13, 15, 14, 10, 5, 1, -2])
city3_err = np.array([0.5, 0.7, 0.6, 0.5, 0.6, 0.5, 0.6, 0.7, 0.6, 0.5, 0.7, 0.5])

city4_avg = np.array([12, 14, 16, 18, 22, 25, 27, 26, 23, 18, 15, 13])
city4_err = np.array([1, 1.2, 1, 1.5, 1, 1.2, 1.3, 1, 1.5, 1, 1.2, 1])

# Axes Labels and Titles
xlabel = "Month"
ylabel = "Average Temperature (°C)"
title_1 = "City 1: Monthly Temperature Variations"
title_2 = "City 2: Monthly Temperature Variations"
title_3 = "City 3: Monthly Temperature Variations"
title_4 = "City 4: Monthly Temperature Variations"

# Colors and Styles
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
line_styles = ["-", "--", "-.", ":"]
marker_shapes = ["o", "s", "^", "D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(16, 5))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=12)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)
    ax.grid(True, alpha=0.3)

# Plot City 1
axs[0].errorbar(
    months, city1_avg, yerr=city1_err, fmt=marker_shapes[0], linestyle=line_styles[0], 
    color=colors[0], ecolor=colors[0], capsize=4, markersize=6
)
axs[0].fill_between(months, city1_avg - city1_err, city1_avg + city1_err, color=colors[0], alpha=0.2)
axs[0].set_title(title_1, fontsize=12)

# Plot City 2
axs[1].errorbar(
    months, city2_avg, yerr=city2_err, fmt=marker_shapes[1], linestyle=line_styles[1], 
    color=colors[1], ecolor=colors[1], capsize=4, markersize=6
)
axs[1].fill_between(months, city2_avg - city2_err, city2_avg + city2_err, color=colors[1], alpha=0.2)
axs[1].set_title(title_2, fontsize=12)

# Plot City 3
axs[2].errorbar(
    months, city3_avg, yerr=city3_err, fmt=marker_shapes[2], linestyle=line_styles[2], 
    color=colors[2], ecolor=colors[2], capsize=4, markersize=6
)
axs[2].fill_between(months, city3_avg - city3_err, city3_avg + city3_err, color=colors[2], alpha=0.2)
axs[2].set_title(title_3, fontsize=12)

# Plot City 4
axs[3].errorbar(
    months, city4_avg, yerr=city4_err, fmt=marker_shapes[3], linestyle=line_styles[3], 
    color=colors[3], ecolor=colors[3], capsize=4, markersize=6
)
axs[3].fill_between(months, city4_avg - city4_err, city4_avg + city4_err, color=colors[3], alpha=0.2)
axs[3].set_title(title_4, fontsize=12)

# Adjust layout
plt.subplots_adjust(wspace=0.3)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_89.pdf", bbox_inches="tight")
