
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for daily sales (in thousands) for different products over a week
days = np.array([1, 2, 3, 4, 5, 6, 7])
product_a_sales = np.array([15, 18, 20, 25, 23, 19, 17])
error_a = np.array([2, 2, 1.5, 2.5, 2, 1.8, 2])

product_b_sales = np.array([10, 12, 11, 14, 13, 12.5, 12])
error_b = np.array([1, 1.2, 1, 1.5, 1.3, 1.1, 1.4])

product_c_sales = np.array([8, 10, 12, 15, 14, 13, 13])
error_c = np.array([1.5, 1.6, 1.7, 2, 2.2, 2, 2.1])

product_d_sales = np.array([14, 16, 15, 18, 17, 18, 16])
error_d = np.array([1, 1.4, 1.3, 1.6, 1.5, 1.2, 1.3])

# Axes Limits and Labels
xlim_values = [0.8, 7.2]
xticks_values = [1, 2, 3, 4, 5, 6, 7]

ylim_values_1 = [10, 30]
yticks_values_1 = range(10, 31, 5)
ylim_values_2 = [9, 15]
yticks_values_2 = range(9, 16, 1)
ylim_values_3 = [7, 17]
yticks_values_3 = range(7, 18, 2)
ylim_values_4 = [12, 20]
yticks_values_4 = range(12, 21, 2)

# Labels
xlabel = "Days"
ylabel = "Sales (in thousands)"

label_a = "Product A"
label_b = "Product B"
label_c = "Product C"
label_d = "Product D"

# Titles
title_a = "Product A Sales Over a Week"
title_b = "Product B Sales Over a Week"
title_c = "Product C Sales Over a Week"
title_d = "Product D Sales Over a Week"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(16, 5))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=12)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)

# Set the specified x and y axis ranges and ticks
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values_1)
axs[0].set_xticks(xticks_values)
axs[0].set_yticks(yticks_values_1)

axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values_2)
axs[1].set_xticks(xticks_values)
axs[1].set_yticks(yticks_values_2)

axs[2].set_xlim(xlim_values)
axs[2].set_ylim(ylim_values_3)
axs[2].set_xticks(xticks_values)
axs[2].set_yticks(yticks_values_3)

axs[3].set_xlim(xlim_values)
axs[3].set_ylim(ylim_values_4)
axs[3].set_xticks(xticks_values)
axs[3].set_yticks(yticks_values_4)

# Plot with error bands
axs[0].errorbar(
    days, product_a_sales, yerr=error_a, fmt="--s", color="darkorange", ecolor="orange", capsize=5, markersize=6
)
axs[0].fill_between(days, product_a_sales - error_a, product_a_sales + error_a, color="orange", alpha=0.2)
axs[0].set_title(title_a, y=-0.2, fontsize=14)
axs[0].grid(True, alpha=0.5)

axs[1].errorbar(
    days, product_b_sales, yerr=error_b, fmt="--d", color="dodgerblue", ecolor="deepskyblue", capsize=5, markersize=6
)
axs[1].fill_between(days, product_b_sales - error_b, product_b_sales + error_b, color="deepskyblue", alpha=0.2)
axs[1].set_title(title_b, y=-0.2, fontsize=14)
axs[1].grid(True, alpha=0.5)

axs[2].errorbar(
    days, product_c_sales, yerr=error_c, fmt="--o", color="forestgreen", ecolor="limegreen", capsize=5, markersize=6
)
axs[2].fill_between(days, product_c_sales - error_c, product_c_sales + error_c, color="limegreen", alpha=0.2)
axs[2].set_title(title_c, y=-0.2, fontsize=14)
axs[2].grid(True, alpha=0.5)

axs[3].errorbar(
    days, product_d_sales, yerr=error_d, fmt="--^", color="indianred", ecolor="salmon", capsize=5, markersize=6
)
axs[3].fill_between(days, product_d_sales - error_d, product_d_sales + error_d, color="salmon", alpha=0.2)
axs[3].set_title(title_d, y=-0.2, fontsize=14)
axs[3].grid(True, alpha=0.5)

# Adjust layout
plt.subplots_adjust(wspace=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_91.pdf", bbox_inches="tight")
