 
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
exercise_types = ["Yoga", "Running", "Cycling", "Weightlifting"]
energy_morning = [8.0, 9.5, 8.5, 7.0]
energy_evening = [7.5, 8.0, 7.8, 6.5]
error = [0.5, 0.4, 0.6, 0.3]

# Axes Limits and Labels
xlabel_value = "Exercise Type"
ylabel_value = "Energy Level (AU)"
ylim_values = [0, 10]

# Labels
label_Morning = "Morning"
label_Evening = "Evening"

# Titles
title = "Time of Day"
supertitle = "Energy Levels After Exercise"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.errorbar(
    exercise_types,
    energy_morning,
    yerr=error,
    fmt="o-",
    color="#1f77b4",  # Blue
    ecolor="#1f77b4",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Morning,
    markerfacecolor='#aec7e8'
)
ax.errorbar(
    exercise_types,
    energy_evening,
    yerr=error,
    fmt="s-",
    color="#ff7f0e",  # Orange
    ecolor="#ff7f0e",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Evening,
    markerfacecolor='#ffbb78'
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_ylim(ylim_values)

ax.tick_params(
    axis="both", which="major", length=6, direction="in", top=True, right=True
)
ax.legend(title=title, loc="lower right", frameon=False)
fig.suptitle(supertitle, fontsize=16)
ax.set_title("")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_92.pdf", bbox_inches="tight")
