
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Genres and Popularity Over Two Years
genres = ["Pop", "Rock", "Jazz", "Classical", "Hip-Hop"]
popularity_2022 = [85, 75, 60, 50, 90]
popularity_2023 = [88, 78, 65, 55, 92]
error_margin = [3, 4, 2, 3, 4]

# Axes Limits and Labels
xlabel_value = "Genre"
ylabel_value = "Popularity Score"
ylim_values = [40, 100]

# Labels
label_2022 = " 2022"
label_2023 = "2023"

# Titles
title = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.errorbar(
    genres,
    popularity_2022,
    yerr=error_margin,
    fmt="*-",
    color="teal",
    ecolor="teal",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_2022,
    linestyle='--'
)
ax.errorbar(
    genres,
    popularity_2023,
    yerr=error_margin,
    fmt="H-",
    color="magenta",
    ecolor="magenta",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_2023,
    linestyle='-.'
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

ax.tick_params(
    axis="both", which="major", length=5, direction="in", top=True, right=True
)
ax.legend(title=title, loc="upper left", frameon=False)
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_93.pdf", bbox_inches="tight")
