
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
investment_strategies = ["Conservative", "Balanced", "Aggressive", "Speculative"]
returns_bull = [5.8, 7.4, 9.1, 12.5]
returns_bear = [-3.2, -1.1, 0.5, 4.8]
error = [0.9, 0.7, 0.4, 0.8]

# Axes Limits and Labels
xlabel_value = "Investment Strategy"
ylabel_value = "Return Percentage (%)"
ylim_values = [-5, 15]

# Labels
label_Bull_Market = "Bull Market"
label_Bear_Market = "Bear Market"

# Titles
title = "Economic Condition"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.errorbar(
    investment_strategies,
    returns_bull,
    yerr=error,
    fmt="h-",
    color="navy",
    ecolor="skyblue",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Bull_Market,
)
ax.errorbar(
    investment_strategies,
    returns_bear,
    yerr=error,
    fmt="d--",
    color="green",
    ecolor="lightgreen",
    elinewidth=2,
    capsize=5,
    capthick=2,
    label=label_Bear_Market,
)

# Customization
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

ax.tick_params(
    axis="both", which="major", length=5, direction="in", top=True, right=True
)
ax.legend(title=title, loc="upper left", frameon=False)
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_94.pdf", bbox_inches="tight")
