
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"]
cbt = [2, 4, 5, 7, 6, 8, 7, 9]
mindfulness = [1, 3, 4, 6, 5, 7, 6, 8]
psychoanalysis = [0.5, 2, 3, 4, 5, 6, 5, 7]

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Labels and Legend
xlabel = "Months"
ylabel = "Performance Gain (%)"
title = "Performance Gain Over Time for Psychological Techniques"
cbt_label = "Cognitive Behavioral Therapy (CBT)"
mindfulness_label = "Mindfulness"
psychoanalysis_label = "Psychoanalysis"

# Limits
xlim = (months[0], months[-1])
ylim = (0, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 7))
ax.plot(months, cbt, label=cbt_label, color="#4C72B0", linestyle='-', marker='o', linewidth=2)
ax.plot(months, mindfulness, label=mindfulness_label, color="#55A868", linestyle='--', marker='s', linewidth=2)
ax.plot(months, psychoanalysis, label=psychoanalysis_label, color="#C44E52", linestyle='-.', marker='d', linewidth=2)

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 10
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of months without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, pad=20)

# Legend
ax.legend(loc="upper left", fontsize=12, frameon=True, fancybox=True, shadow=True)

# Grid
ax.grid(True, ls="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_99.pdf", bbox_inches="tight")
