
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Picture in Picture bar plot
tourist_known_visits = np.array([12000, 11000, 8500, 7000, 6000, 4500, 3000, 2000, 1500, 1200, 1000])
tourist_unknown_visits = np.array([8000, 7500, 5000, 4000, 3000, 2000, 1500, 1000, 800, 600, 400])
bins = np.linspace(0, 0.5, 11)

# Data for the heatmap
attraction_ratings = np.array([
    [85, 80, 78, 75, 70, 65],
    [88, 82, 80, 78, 73, 68],
    [90, 85, 83, 80, 75, 70],
    [92, 88, 85, 83, 78, 72],
    [95, 90, 88, 85, 80, 75],
])
x_labels = ["Beach", "Museum", "Park", "Market", "Theater", "Zoo"]
y_labels = ["Region 1", "Region 2", "Region 3", "Region 4", "Region 5"]
bar_labels = ["Known Visits", "Unknown Visits"]
xlabels = ["Attraction Popularity", "Tourist Attractions"]
ylabels = ["Number of Visits", "Regions"]
cbarlabel = "Attraction Ratings"
insetaxes = [0.251, 0.5, 0.1, 0.2]
insetxlim = [0.25, 0.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with GridSpec
fig = plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1.5])

# Picture in Picture bar plot
ax0 = plt.subplot(gs[0])
ax0.bar(bins, tourist_known_visits, width=0.04, color="#1f77b4", align="center", label=bar_labels[0], edgecolor="black")
ax0.bar(bins, tourist_unknown_visits, width=0.04, color="#ff7f0e", align="center", bottom=tourist_known_visits, label=bar_labels[1], edgecolor="black")
ax0.set_xlabel(xlabels[0])
ax0.set_ylabel(ylabels[0])
ax0.legend(loc="upper right")
ax0.grid(True)

# Add inset
ax_inset = fig.add_axes(insetaxes)
ax_inset.bar(bins[5:], tourist_known_visits[5:], width=0.04, color="#1f77b4", align="center", edgecolor="black")
ax_inset.bar(bins[5:], tourist_unknown_visits[5:], width=0.04, color="#ff7f0e", align="center", bottom=tourist_known_visits[5:], edgecolor="black")
ax_inset.set_xlim(insetxlim)

# Heatmap plot
ax1 = plt.subplot(gs[1])
cmap = plt.cm.viridis_r
norm = plt.Normalize(vmin=attraction_ratings.min(), vmax=attraction_ratings.max())
heatmap = ax1.imshow(attraction_ratings, cmap=cmap, norm=norm, aspect="auto")

# Add color bar
cbar = plt.colorbar(heatmap, ax=ax1, orientation="vertical", pad=0.1)
cbar.set_label(cbarlabel)

# Set x and y labels
ax1.set_xticks(np.arange(len(x_labels)))
ax1.set_yticks(np.arange(len(y_labels)))
ax1.set_xticklabels(x_labels, rotation=45)
ax1.set_yticklabels(y_labels)
ax1.set_xlabel(xlabels[1])
ax1.set_ylabel(ylabels[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_100.pdf", bbox_inches="tight")
