
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Treemap data for social media daily active users by age group
sizes_treemap = [35, 30, 20, 10, 5]
labels_treemap = [
    "13-18\n35%",
    "19-25\n30%",
    "26-35\n20%",
    "36-45\n10%",
    "46+\n5%",
]

# Pie chart data for percentage distribution of time spent on social media by age group
sizes_pie = [30, 25, 25, 15, 5]
labels_pie = ["13-18", "19-25", "26-35", "36-45", "46+"]

title = "Time Spent on Social Media by Age Group"


explode_pie = (0.1, 0.1, 0, 0, 0)  # Highlight the first two slices

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set GridSpec
fig = plt.figure(figsize=(12, 6))
gs = GridSpec(1, 2, figure=fig)
# New colors
colors_treemap = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854"]
colors_pie = ["#ffd92f", "#a6d854", "#e5c494", "#b3b3b3", "#66c2a5"]

# Create treemap subplot
ax1 = fig.add_subplot(gs[0, 0])
squarify.plot(
    sizes=sizes_treemap,
    label=labels_treemap,
    color=colors_treemap,
    alpha=0.7,
    text_kwargs={"fontsize": 16},
)
ax1.axis("off")  # Disable the axes

# Create pie chart subplot
ax2 = fig.add_subplot(gs[0, 1])
wedges, texts, autotexts = ax2.pie(
    sizes_pie,
    explode=explode_pie,
    labels=labels_pie,
    colors=colors_pie,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
    textprops={'fontsize': 14}
)
ax2.set_title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_27.pdf", bbox_inches="tight")
