
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Treemap data for religious resources allocation by region
sizes_treemap = [50, 30, 10, 5, 3, 2]
labels_treemap = [
    "Christianity\n50%",
    "Islam\n30%",
    "Hinduism\n10%",
    "Buddhism\n5%",
    "Judaism\n3%",
    "Others\n2%",
]

# Pie chart data for literacy rates in religious communities
sizes_pie = [70, 50, 60, 55, 65]
labels_pie = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism"]

title = "Literacy Rate by Religious Community"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors_treemap = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#C2C2F0", "#FFB3E6"]
colors_pie = ["#FF6666", "#66B2FF", "#99FF99", "#FFCC99", "#C2C2F0"]
explode_pie = (0.1, 0, 0, 0, 0)  # Highlight the first slice

# Create figure and set GridSpec
fig = plt.figure(figsize=(12, 6))
gs = GridSpec(1, 2, figure=fig)

# Create treemap subplot
ax1 = fig.add_subplot(gs[0, 0])
squarify.plot(
    sizes=sizes_treemap,
    label=labels_treemap,
    color=colors_treemap,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "fontweight": "bold"},
)
ax1.axis("off")  # Disable the axes

# Create pie chart subplot
ax2 = fig.add_subplot(gs[0, 1])
wedges, texts, autotexts = ax2.pie(
    sizes_pie,
    explode=explode_pie,
    labels=labels_pie,
    colors=colors_pie,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
    textprops={'fontsize': 12, 'fontweight': 'bold'}
)
ax2.set_title(title, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_28.pdf", bbox_inches="tight")
