
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the histogram: crime rates in different regions
crime_rates_urban = np.random.normal(loc=50, scale=15, size=1000)
crime_rates_rural = np.random.normal(loc=30, scale=10, size=1000)

# Data for the pie chart: budget allocation for law enforcement departments
labels = ["Police", "Judiciary", "Corrections", "Community Programs", "Administration"]
budget = [35, 25, 20, 10, 10]
explode = (0.1, 0, 0, 0, 0)  # highlight the largest segment
titles = ["Crime Rates in Different Regions", "Budget Allocation for Law Enforcement"]
xlabel = "Crime Rate per 100,000 Inhabitants"
ylabel = "Number of Regions"
histlabels = ["Urban Areas", "Rural Areas"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
# Set up the figure and grid
fig = plt.figure(figsize=(10, 5))
gs = gridspec.GridSpec(1, 2, figure=fig)

# Histogram plot
axes1 = fig.add_subplot(gs[0, 0])
axes1.hist(
    [crime_rates_urban, crime_rates_rural],
    bins=50,
    stacked=True,
    color=["#1f77b4", "#d62728"],
    label=histlabels,
)
axes1.set_title(titles[0])
axes1.set_xlabel(xlabel)
axes1.set_ylabel(ylabel)
axes1.legend(loc="upper right")

# Pie chart plot
axes2 = fig.add_subplot(gs[0, 1])
axes2.pie(
    budget,
    explode=explode,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
)
axes2.set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_29.pdf", bbox_inches="tight")
