
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the histogram: technology adoption scores
tech_enthusiasts = np.random.normal(loc=80, scale=8, size=1000)
casual_users = np.random.normal(loc=60, scale=15, size=1000)

# Data for the pie chart: budget allocation
labels = ["R&D", "Marketing", "Development", "Customer Support", "Infrastructure"]
budget = [25, 20, 35, 15, 5]
explode = (0.1, 0, 0, 0, 0)  # highlight the largest segment
titles = ["Technology Adoption Scores", "Technology Budget Allocation"]
xlabel = "Score"
ylabel = "Number of Users"
histlabels = ["Tech Enthusiasts", "Casual Users"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E86C1", "#AED6F1", "#28B463", "#A9DFBF", "#AF7AC5"]
# Set up the figure and grid
fig = plt.figure(figsize=(10, 5))
gs = gridspec.GridSpec(1, 2, figure=fig)

# Histogram plot
axes1 = fig.add_subplot(gs[0, 0])
axes1.hist(
    [tech_enthusiasts, casual_users],
    bins=50,
    stacked=True,
    color=["#5DADE2", "#76D7C4"],
    label=histlabels,
    edgecolor='black'
)
axes1.set_title(titles[0], fontsize=14, fontweight='bold')
axes1.set_xlabel(xlabel, fontsize=12)
axes1.set_ylabel(ylabel, fontsize=12)
axes1.legend(loc="upper right", fontsize=10)
axes1.grid(True, linestyle='--', alpha=0.7)

# Pie chart plot
axes2 = fig.add_subplot(gs[0, 1])
wedges, texts, autotexts = axes2.pie(
    budget,
    explode=explode,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
    textprops=dict(color="w")
)
axes2.set_title(titles[1], fontsize=14, fontweight='bold')
for text in texts + autotexts:
    text.set_fontsize(10)
axes2.axis('equal')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_31.pdf", bbox_inches="tight")
