
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for the histogram representing post interactions (likes and comments)
post_likes = np.random.normal(loc=75, scale=20, size=1000)  # Average of 75 likes
post_comments = np.random.normal(loc=30, scale=10, size=1000)  # Average of 30 comments

# Generate sample data for the scatter plot representing user engagement clusters
likes = np.random.normal(100, 30, 100)
shares = np.random.normal(20, 5, 100)
comments = np.random.normal(50, 15, 100)

ax1title = "Histogram of Post Interactions"
ax1xlabel = "Number of Interactions"
ax1ylabel = "Frequency"
ax1legend = ["Likes", "Comments"]
ax2title = "User Engagement Clusters"
ax2labels = ["Influencers", "Regular Users"]
xlabel="Engagement Metric 1 (Likes/Comments)"
ylabel="Engagement Metric 2 (Shares)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram for post interactions
# Create a figure and a 1x2 grid layout
fig = plt.figure(figsize=(12, 6))
gs = GridSpec(1, 2, figure=fig)

ax1 = fig.add_subplot(gs[0, 0])
ax1.hist(
    [post_likes, post_comments], bins=50, stacked=True, color=["#FF6F61", "#6B5B95"], alpha=0.7
)
ax1.set_title(ax1title)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.legend(ax1legend)

# Scatter plot for user engagement clusters
ax2 = fig.add_subplot(gs[0, 1])
ax2.scatter(likes, shares, c="#FF6F61", label=ax2labels[0], alpha=0.7, edgecolors='w', s=100)
ax2.scatter(comments, shares, c="#6B5B95", label=ax2labels[1], alpha=0.7, edgecolors='w', s=100)
ax2.set_title(ax2title)
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabel)
ax2.legend()
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save to file
plt.tight_layout()
plt.savefig("multidiff_34.pdf", bbox_inches="tight")
