
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define functions to simulate health data
def heart_rate(t):
    return 60 + 15 * np.sin(2 * np.pi * t / 24) + np.random.normal(0, 2, len(t))

# Time intervals
t1 = np.arange(0.0, 48.0, 1.0)  # Every hour for 2 days
t2 = np.arange(0.0, 48.0, 0.5)  # Every half hour for 2 days

# 3D Data for physical activity levels
X = np.arange(-5, 5, 0.25)
Y = np.arange(-5, 5, 0.25)
X, Y = np.meshgrid(X, Y)
Z = np.sin(np.sqrt(X**2 + Y**2)) * np.exp(-0.1 * (X**2 + Y**2))

# Axes Limits and Labels
ylabel_value_1 = "Heart Rate (bpm)"
xlabel_value_1 = "Time (hours)"

zlim_values = [-0.5, 0.5]
xlabel_value_2 = "X Position"
ylabel_value_2 = "Y Position"
zlabel_value_2 = "Activity Level"
labels=["Hourly Data", "Half-hour Data"]
titles=["Heart Rate Trends Over Time","3D Surface Plot of Activity Levels"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up a figure twice as tall as it is wide
fig = plt.figure(figsize=(8, 10))

# First subplot for heart rate trends
ax = fig.add_subplot(2, 1, 1)
ax.plot(t1, heart_rate(t1), "bo-", label=labels[0], markerfacecolor="blue")
ax.plot(t2, heart_rate(t2), "g--", label=labels[1], linewidth=2)
ax.grid(True)
ax.set_ylabel(ylabel_value_1)
ax.set_xlabel(xlabel_value_1)
ax.legend(loc="best")
ax.set_title(titles[0])

# Second subplot for 3D surface plot of activity levels
ax = fig.add_subplot(2, 1, 2, projection="3d")
surf = ax.plot_surface(X, Y, Z, cmap="viridis", edgecolor='k', rstride=1, cstride=1, linewidth=0, antialiased=False)
ax.set_zlim(zlim_values)
ax.set_xlabel(xlabel_value_2)
ax.set_ylabel(ylabel_value_2)
ax.set_zlabel(zlabel_value_2)
ax.set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show the plot
plt.savefig("multidiff_37.pdf", bbox_inches="tight")
