
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Scientific fields for the pie chart
fields = ["Physics", "Chemistry", "Biology", "Computer Science"]
publication_counts = [250, 400, 300, 450]

# Publication years and counts for the scatter plot
time_periods = ["1980", "1990", "2000", "2010", "2020"]
years = [1980, 1990, 2000, 2010, 2020]
pub_counts = [50, 150, 250, 350, 450]

# Axes Limits and Labels
title_1 = "Publications by Scientific Field"
title_2 = "Publication Counts Over Years"
xlabel_value = "Year"
ylabel_value = "Number of Publications"
ylim_values = [0, 500]
xlim_values = [1975, 2025]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set up GridSpec
fig = plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1])

# Create pie chart on the left
ax1 = fig.add_subplot(gs[0])
pie_colors = ["#008080", "#FF7F50", "#9370DB", "#87CEEB"]
wedges, texts, autotexts = ax1.pie(
    publication_counts,
    labels=fields,
    autopct="%1.1f%%",
    startangle=90,
    colors=pie_colors,
)
ax1.set_title(title_1, fontsize=14)

# Create scatter plot on the right
ax2 = fig.add_subplot(gs[1])
scatter = ax2.scatter(
    years,
    pub_counts,
    color="#FF6347",
    s=np.array(pub_counts) * 1.5,
    alpha=0.7,
    edgecolor="black",
    marker='o'
)
ax2.set_title(title_2, fontsize=14)
ax2.set_xlabel(xlabel_value, fontsize=12)
ax2.set_ylabel(ylabel_value, fontsize=12)
ax2.grid(True, linestyle='--', linewidth=0.7)
ax2.set_ylim(ylim_values)
ax2.set_xlim(xlim_values)

# Add text labels to scatter points
for i, txt in enumerate(time_periods):
    ax2.annotate(txt, (years[i], pub_counts[i] + 25), fontsize=10, ha='center')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_38.pdf", bbox_inches="tight")
