
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Communication Methods for the pie chart
communication_methods = [
    "Emails",
    "Phone Calls",
    "Text Messages",
    "Video Calls",
]
communication_counts = [250, 150, 350, 250]

# Years and communication counts for the scatter plot
years_commun = [2000, 2005, 2010, 2015, 2020]
emails_count = [100, 200, 400, 500, 600]
phone_calls_count = [150, 130, 120, 110, 100]
text_messages_count = [80, 150, 300, 450, 550]
video_calls_count = [10, 20, 50, 100, 200]

# Axes Limits and Labels
title_1 = "Communication Methods in Modern Times"

title_2 = "Communication Method Usage Over Years"
xlabel_value = "Year"
ylabel_value = "Usage Count"
ylim_values = [0, 700]
xlim_values = [1995, 2025]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set up GridSpec
fig = plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1])

# Create pie chart on the left
ax1 = fig.add_subplot(gs[0])
wedges, texts, autotexts = ax1.pie(
    communication_counts,
    labels=communication_methods,
    autopct="%1.1f%%",
    startangle=140,
    colors=["#FF9999","#66B2FF","#99FF99","#FFD700"],
)
ax1.set_title(title_1)

# Create scatter plot on the right
ax2 = fig.add_subplot(gs[1])
scatter_emails = ax2.scatter(
    years_commun,
    emails_count,
    color="#FF9999",
    s=np.array(emails_count)/2,
    alpha=0.7,
    edgecolor="black",
    label="Emails"
)
scatter_phone_calls = ax2.scatter(
    years_commun,
    phone_calls_count,
    color="#66B2FF",
    s=np.array(phone_calls_count)/2,
    alpha=0.7,
    edgecolor="black",
    label="Phone Calls"
)
scatter_text_messages = ax2.scatter(
    years_commun,
    text_messages_count,
    color="#99FF99",
    s=np.array(text_messages_count)/2,
    alpha=0.7,
    edgecolor="black",
    label="Text Messages"
)
scatter_video_calls = ax2.scatter(
    years_commun,
    video_calls_count,
    color="#FFD700",
    s=np.array(video_calls_count)/2,
    alpha=0.7,
    edgecolor="black",
    label="Video Calls"
)

ax2.set_title(title_2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.grid(True)
ax2.set_ylim(ylim_values)
ax2.set_xlim(xlim_values)

# Add text labels to scatter points
for i, year in enumerate(years_commun):
    ax2.annotate(f'{year}', (year, emails_count[i]), textcoords="offset points", xytext=(0,10), ha='center')

# Add legend to the scatter plot
ax2.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_39.pdf", bbox_inches="tight")

