
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to represent different types of fruits
fruits = ["Apple", "Banana", "Cherry", "Date", "Elderberry"]
prices = [3.0, 1.2, 5.5, 7.0, 9.0]  # Average price per kg for each fruit in dollars
popularity = [9.0, 8.8, 7.5, 6.0, 4.5]  # Popularity index out of 10

# Data for violin plot; customer satisfaction scores (1-10 scale)
satisfaction_data = np.random.normal(loc=[8, 7, 6, 5, 7], scale=0.5, size=(50, 5))

ax0xlabel = "Average Price per kg ($)"
ax0ylabel = "Popularity Index"
ax0title = "Fruit Popularity vs Price"
ax1xticks = range(len(fruits))
ax1xlabel = "Fruits"
ax1ylabel = "Customer Satisfaction"
ax1title = "Customer Satisfaction Distribution Across Fruits"
x = np.linspace(1, 10, 300)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 1x2 subplot layout
fig = plt.figure(figsize=(10, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 2])

# Scatter plot on the left
ax0 = fig.add_subplot(gs[0])
sc = ax0.scatter(
    prices, popularity, s=100, c=np.linspace(0.1, 0.9, len(fruits)), cmap="autumn"
)
for i, fruit in enumerate(fruits):
    ax0.text(prices[i], popularity[i] + 0.05, fruit, fontsize=9)
ax0.set_xlabel(ax0xlabel)
ax0.set_ylabel(ax0ylabel)
ax0.set_title(ax0title)

# Violin plot on the right
ax1 = fig.add_subplot(gs[1])

# Creating half-violins
for i, fruit in enumerate(fruits):
    kde = gaussian_kde(satisfaction_data[:, i])
    y = kde(x)
    max_y = max(y)
    ax1.fill_betweenx(
        x, -y / max_y * 0.5 + i, i, color="lightgreen", alpha=0.5)
    ax1.fill_betweenx(
        x, y / max_y * 0.5 + i, i, color="green", alpha=0.5)

ax1.set_xticks(ax1xticks)
ax1.set_xticklabels(fruits)
ax1.set_xlabel(ax1xlabel)
ax1.set_ylabel(ax1ylabel)
ax1.set_title(ax1title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
# Show plot
plt.savefig("multidiff_42.pdf", bbox_inches="tight")
