
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plots
import numpy as np

np.random.seed(1)

students = [
    "Student A",
    "Student B",
    "Student C",
    "Student D",
    "Student E",
    "Student F"
]
exam_scores = [85.2, 78.4, 91.5, 69.0, 74.3, 88.6]
assignment_scores = [81.5, 77.2, 89.6, 72.5, 76.5, 84.3]
exam_diff = np.random.randn(6, 6) * 5
assignment_diff = np.random.randn(6, 6) * 5
score_diff = np.random.randn(6, 6) * 4
assignment_effort_diff = np.random.randn(6, 6) * 4
titles = [
    "Exam Scores (%)",
    "Assignment Scores (%)",
    "Exam Score Differences",
    "Assignment Score Differences",
    "Score Differences",
    "Assignment Effort Differences"
]
xlim1 = [0, 100]
xlim2 = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(12, 8))

# Plot Exam Scores
axs[0, 0].barh(students, exam_scores, color="#a1dab4")
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()  # Reverse the order for readability
# annotate the bars with the values
for i, v in enumerate(exam_scores):
    axs[0, 0].text(v + 0.5, i, str(v), color="black", va="center")

# Plot Assignment Scores
axs[1, 0].barh(students, assignment_scores, color="#41b6c4")
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()  # Reverse the order for readability
# annotate the bars with the values
for i, v in enumerate(assignment_scores):
    axs[1, 0].text(v + 0.5, i, str(v), color="black", va="center")

# Plot Exam Score Differences
im1 = axs[0, 1].imshow(exam_diff, cmap="RdYlBu", aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(students)):
    for j in range(len(students)):
        text = axs[0, 1].text(
            j,
            i,
            round(exam_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(exam_diff[i, j]) < 3 else "white",
        )
axs[0, 1].axis("off")

# Plot Assignment Score Differences
im2 = axs[1, 1].imshow(assignment_diff, cmap="RdYlBu", aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(students)):
    for j in range(len(students)):
        text = axs[1, 1].text(
            j,
            i,
            round(assignment_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(assignment_diff[i, j]) < 3 else "white",
        )
axs[1, 1].axis("off")

# Plot Score Differences
im3 = axs[0, 2].imshow(score_diff, cmap="RdYlBu", aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(students)):
    for j in range(len(students)):
        text = axs[0, 2].text(
            j,
            i,
            round(score_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(score_diff[i, j]) < 3 else "white",
        )
axs[0, 2].axis("off")

# Plot Assignment Effort Differences
im4 = axs[1, 2].imshow(assignment_effort_diff, cmap="RdYlBu", aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(students)):
    for j in range(len(students)):
        text = axs[1, 2].text(
            j,
            i,
            round(assignment_effort_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(assignment_effort_diff[i, j]) < 3 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_45.pdf", bbox_inches="tight")
