
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Tourist Destinations and corresponding data
destinations = ["Paris", "London", "New York", "Tokyo", "Dubai", "Sydney"]
tourist_numbers = [34.5, 29.8, 27.7, 31.2, 26.4, 25.3]  # in thousands
spend_per_tourist = [1200, 1100, 1050, 1300, 1250, 1150]  # in USD

# Difference Matrices
tourist_numbers_diff = np.random.uniform(-5, 5, (6, 6))
spend_diff = np.random.uniform(-200, 200, (6, 6))
unfavorable_reviews = np.random.uniform(0, 10, (6, 6))
year_over_year_growth = np.random.uniform(-5, 5, (6, 6))

# Titles and Labels
titles = [
    "Number of Tourists (in thousands)",
    "Average Spend per Tourist (in USD)",
    "Tourist Numbers Difference",
    "Spend per Tourist Difference",
    "Unfavorable Reviews (%)",
    "Year-Over-Year Growth (%)"
]
xlim1 = [0, 40]
xlim2 = [0, 1500]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(15, 10))

# Plot Number of Tourists
axs[0, 0].barh(destinations, tourist_numbers, color="skyblue")
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()  # Reverse the order
for i, v in enumerate(tourist_numbers):
    axs[0, 0].text(v + 0.4, i, str(v), color="black", va="center")

# Plot Average Spend per Tourist
axs[1, 0].barh(destinations, spend_per_tourist, color="salmon")
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()  # Reverse the order
for i, v in enumerate(spend_per_tourist):
    axs[1, 0].text(v + 20, i, str(v), color="black", va="center")

# Plot Tourist Numbers Difference
im1 = axs[0, 1].imshow(tourist_numbers_diff, cmap="coolwarm", aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(destinations)):
    for j in range(len(destinations)):
        text = axs[0, 1].text(
            j,
            i,
            round(tourist_numbers_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(tourist_numbers_diff[i, j]) < 2.5 else "white",
        )
axs[0, 1].axis("off")

# Plot Spend per Tourist Difference
im2 = axs[1, 1].imshow(spend_diff, cmap="coolwarm", aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(destinations)):
    for j in range(len(destinations)):
        text = axs[1, 1].text(
            j,
            i,
            round(spend_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(spend_diff[i, j]) < 100 else "white",
        )
axs[1, 1].axis("off")

# Plot Unfavorable Reviews
im3 = axs[0, 2].imshow(unfavorable_reviews, cmap="coolwarm", aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(destinations)):
    for j in range(len(destinations)):
        text = axs[0, 2].text(
            j,
            i,
            round(unfavorable_reviews[i, j], 2),
            ha="center",
            va="center",
            color="black" if unfavorable_reviews[i, j] < 5 else "white",
        )
axs[0, 2].axis("off")

# Plot Year-Over-Year Growth
im4 = axs[1, 2].imshow(year_over_year_growth, cmap="coolwarm", aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(destinations)):
    for j in range(len(destinations)):
        text = axs[1, 2].text(
            j,
            i,
            round(year_over_year_growth[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(year_over_year_growth[i, j]) < 2.5 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_46.pdf", bbox_inches="tight")
