
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Assuming data values for the bar chart
categories = ["Stock A", "Stock B", "Stock C", "Stock D", "Stock E", "Stock F"]
values = [12.5, 11.0, 8.5, 7.0, 4.5, 2.0]

# Generate y values for the line chart with a monotonically decreasing array
# Creating arrays for y values with 26 numbers each and random add or subtract 0.01 to make them different
value_strategy1 = np.linspace(1, 0.5, 26) + np.random.normal(0, 0.02, 26)
value_strategy2 = np.linspace(0.95, 0.45, 26) + np.random.normal(0, 0.02, 26)
value_strategy3 = np.linspace(0.9, 0.4, 26) + np.random.normal(0, 0.02, 26)
value_strategy4 = np.linspace(0.85, 0.35, 26) + np.random.normal(0, 0.02, 26)
value_strategy5 = np.linspace(0.8, 0.3, 26) + np.random.normal(0, 0.02, 26)
value_strategy6 = np.linspace(0.75, 0.25, 26) + np.random.normal(0, 0.02, 26)

# Axes Limits and Labels
xlabel_value_1 = "Average Annual Return (%)"
xlim_values_1 = [0, 15]
xticks_all_1 = np.arange(0, 16, 1)
xticks_labeled_1 = np.arange(0, 16, 5)

xticks_2 = np.arange(0, 26, 1)
label_strategy1 = "Strategy 1"
label_strategy2 = "Strategy 2"
label_strategy3 = "Strategy 3"
label_strategy4 = "Strategy 4"
label_strategy5 = "Strategy 5"
label_strategy6 = "Strategy 6"
xlabel_value_2 = "Trading Days"
ylabel_value_2 = "Regret"
ylim_values_2 = [0, 1.2]
xticks_all_2 = np.arange(0, 26, 1)
xticks_labeled_2 = np.arange(0, 26, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
bar_colors = ["#2E8B57", "#66CDAA", "#48D1CC", "#20B2AA", "#5F9EA0", "#4682B4"]
ax1.barh(categories, values, color=bar_colors)
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# Create line chart
trials = xticks_2
ax2.plot(trials, value_strategy1, label=label_strategy1, color="#FF6347", linestyle="-")
ax2.plot(trials, value_strategy2, label=label_strategy2, color="#FFA07A", linestyle="--")
ax2.plot(trials, value_strategy3, label=label_strategy3, color="#CD5C5C", linestyle="-.")
ax2.plot(trials, value_strategy4, label=label_strategy4, color="#DC143C", linestyle=":")
ax2.plot(trials, value_strategy5, label=label_strategy5, color="#B22222", linestyle="-")
ax2.plot(trials, value_strategy6, label=label_strategy6, color="#8B0000", linestyle="--")
ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit to match the uploaded image aspect
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_47.pdf", bbox_inches="tight")
