
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for two heatmaps and one bar chart related to societal factors
num_attributes = 5
heatmap_data1 = np.random.rand(num_attributes, num_attributes) * 2 - 1
heatmap_data2 = np.random.rand(num_attributes, num_attributes) * 2 - 1
bar_data = np.abs(np.random.rand(num_attributes) - 0.7)

attributes = ["Employment", "Median Income", "Literacy", "Internet Access", "Healthcare"]
heatmap_title = "Societal Attribute Correlation"
bar_xlabel = "Impact Score"
bar_xticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific dimensions
fig = plt.figure(figsize=(10, 3))  # Adjust as needed

# Create a grid for subplots with adjusted width ratios
grid = plt.GridSpec(1, 3, width_ratios=[4, 4, 4], wspace=0.2)

# Blue-Green color map
cmap = plt.cm.get_cmap("BuGn")

# Create first heatmap subplot
heatmap_ax1 = plt.subplot(grid[0])
heatmap1 = heatmap_ax1.imshow(
    heatmap_data1, cmap=cmap, aspect="auto", vmin=-1, vmax=1.5, alpha=0.8
)
heatmap_ax1.set_xticks(np.arange(len(attributes)))
heatmap_ax1.set_yticks(np.arange(len(attributes)))
heatmap_ax1.set_xticklabels(attributes, rotation=45, ha="right")
heatmap_ax1.set_yticklabels(attributes)
heatmap_ax1.set_xlabel(heatmap_title, fontsize=12)

# Create second heatmap subplot
heatmap_ax2 = plt.subplot(grid[1])
heatmap2 = heatmap_ax2.imshow(
    heatmap_data2, cmap=cmap, aspect="auto", vmin=-1, vmax=1.5, alpha=0.8
)
heatmap_ax2.set_xticks(np.arange(len(attributes)))
heatmap_ax2.set_yticks(np.arange(len(attributes)))
heatmap_ax2.set_xticklabels(attributes, rotation=45, ha="right")
heatmap_ax2.set_yticklabels([])
heatmap_ax2.set_xlabel(heatmap_title, fontsize=12)
heatmap_ax2.yaxis.set_visible(False)

# Create an axes on the top side of ax_heatmap_top for the colorbar.
ax_colorbar = fig.add_axes(
    [
        heatmap_ax1.get_position().x0,
        heatmap_ax1.get_position().y1 + 0.05,
        heatmap_ax1.get_position().width * 2.1,
        0.05,
    ]
)
# Adding a colorbar at the very top of the heatmap
cbar = plt.colorbar(heatmap1, cax=ax_colorbar, orientation="horizontal")
cbar.ax.xaxis.set_ticks_position("top")

# Create bar chart subplot
bar_ax = plt.subplot(grid[2])
bar_ax.barh(attributes[::-1], bar_data, color=cmap(bar_data))
bar_ax.set_xlabel(bar_xlabel, fontsize=12)
bar_ax.set_xticks(bar_xticks)
bar_ax.yaxis.set_visible(False)
bar_ax.grid(True, linestyle='--', alpha=0.7)
bar_ax.set_ylim(heatmap_ax1.get_ylim())

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_53.pdf", bbox_inches="tight")
