
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Data for the bar chart
import numpy as np
teaching_methods = [
    "Traditional (T1)",
    "Flipped Classroom (T2)",
    "E-learning (T3)",
    "Hybrid Learning (T4)",
    "Hands-on (T5)",
    "Collaborative (T6)",
    "Gamification (T7)",
]
performance_scores = [75.5, 78.0, 82.5, 80.0, 85.0, 83.5, 90.0]

# Data for the heatmap, representing effectiveness correlation matrix
effectiveness_corr = np.array(
    [
        [1.00, 0.65, 0.75, 0.80, 0.60, 0.70, 0.85],
        [0.65, 1.00, 0.85, 0.70, 0.75, 0.80, 0.90],
        [0.75, 0.85, 1.00, 0.78, 0.77, 0.88, 0.92],
        [0.80, 0.70, 0.78, 1.00, 0.82, 0.74, 0.81],
        [0.60, 0.75, 0.77, 0.82, 1.00, 0.65, 0.79],
        [0.70, 0.80, 0.88, 0.74, 0.65, 1.00, 0.89],
        [0.85, 0.90, 0.92, 0.81, 0.79, 0.89, 1.00],
    ]
)

# Titles and labels
ax1title = "Student Performance Scores (%)"
ax2title = "Effectiveness Correlation"
ax1xlabel = "Performance Score"
ax2xlabel = "Teaching Methodology"
ax1xlim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(12, 7), gridspec_kw={"width_ratios": [1, 1.25]}
)

# Bar chart
y_pos = np.arange(len(teaching_methods))
ax1.barh(y_pos, performance_scores, color="#3b7dd8")
ax1.set_yticks(y_pos)
ax1.set_yticklabels(teaching_methods, fontsize=10)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_title(ax1title, fontsize=12)
ax1.set_xlabel(ax1xlabel, fontsize=10)
ax1.set_xlim(ax1xlim)
for i, v in enumerate(performance_scores):
    ax1.text(v - 10.0, i, "{:.1f}".format(v), color="white", va="center")

# Heatmap
im = ax2.imshow(effectiveness_corr, cmap="Blues", aspect="auto")

# Show all ticks and label them with the respective list entries
ax2.set_xticks(np.arange(len(teaching_methods)))
ax2.set_xticklabels(teaching_methods, fontsize=10)
ax2.yaxis.set_visible(False)

# Rotate the tick labels and set their alignment.
plt.setp(ax2.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(teaching_methods)):
    for j in range(len(teaching_methods)):
        text = ax2.text(
            j, i, "{:.2f}".format(effectiveness_corr[i, j]), ha="center", va="center", color="black"
        )

ax2.set_title(ax2title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_56.pdf", bbox_inches="tight")
