
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data for the bar chart
models = [
    "Model A (M1)",
    "Model B (M2)",
    "Model C (M3)",
    "Model D (M4)",
    "Model E (M5)",
    "Model F (M6)",
    "Model G (M7)",
]
error_rates = [12.5, 14.3, 10.8, 13.7, 9.4, 11.6, 8.9]

# Data for the heatmap
interaction_matrix = np.array(
    [
        [0.00, 1.20, 0.90, 1.25, 1.10, 0.85, 0.75],
        [1.35, 0.00, 1.05, 1.00, 1.25, 0.95, 0.90],
        [0.95, 1.00, 0.00, 1.15, 1.10, 0.80, 0.70],
        [1.10, 1.05, 1.15, 0.00, 1.20, 0.90, 0.85],
        [1.05, 1.00, 1.10, 1.20, 0.00, 0.85, 0.80],
        [0.95, 0.90, 0.85, 0.90, 0.85, 0.00, 0.75],
        [0.85, 0.80, 0.75, 0.85, 0.80, 0.75, 0.00],
    ]
)
ax1title = "Error Rates (%)"
ax2title = "Interaction Matrix (%)"
ax1xlim = [0, 20]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(10, 6), gridspec_kw={"width_ratios": [1, 1.25]}
)

# Bar chart
y_pos = np.arange(len(models))
ax1.barh(y_pos, error_rates, color="#3498db")
ax1.set_yticks(y_pos)
ax1.set_yticklabels(models, fontsize=10)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_title(ax1title, fontsize=12)
ax1.set_xlim(ax1xlim)
for i, v in enumerate(error_rates):
    ax1.text(v - 2.0, i, "{:.2f}".format(v), color="white", va="center")

# Heatmap
im = ax2.imshow(interaction_matrix, cmap="YlGnBu", aspect="auto")

# We want to show all ticks...
ax2.set_xticks(np.arange(len(models)))
# ax2.set_yticks(np.arange(len(models)))
# ... and label them with the respective list entries
ax2.set_xticklabels(models, fontsize=10)
ax2.yaxis.set_visible(False)

# Rotate the tick labels and set their alignment.
plt.setp(ax2.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(models)):
    for j in range(len(models)):
        text = ax2.text(
            j, i, "{:.2f}".format(interaction_matrix[i, j]), ha="center", va="center", color="black"
        )

ax2.set_title(ax2title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_57.pdf", bbox_inches="tight")
