
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the philosophy domain
# Sample data for the line plot
x = np.array([0, 10000, 20000, 30000, 40000, 50000])
y = np.array([-6, -6.5, -7, -7.2, -7.5, -8])
error = np.array([0.3, 0.25, 0.35, 0.3, 0.4, 0.35])

# Sample data for the box plot
data = [np.random.normal(5, 1, 100) for _ in range(5)]
positions = [0, 10000, 20000, 30000, 40000]
# Scatter data points
scatters_data = np.random.normal(15, 3, len(positions))

titles = ["(a) Text Complexity Over Time", "(b) Complexity Distribution by Period"]
xlabels = ["Number of Texts Analyzed", "Period"]
ylabels = ["Complexity Score", "Complexity Score"]
xtickslabels = [
    ["0", "10k", "20k", "30k", "40k", "50k"],
    ["0", "10k", "20k", "30k", "40k"],
]
yticks = [np.arange(-6, -9, -0.5), np.arange(0, 20, 5)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, axs = plt.subplots(2, 1, figsize=(5, 6))

# Line plot
axs[0].errorbar(
    x,
    y,
    yerr=error,
    fmt="o-",
    ecolor="lightblue",
    markersize=8,
    linewidth=1,
    color="darkblue",
    linestyle='--',
    marker='s'
)
axs[0].fill_between(x, y - error, y + error, color="lightblue", alpha=0.5)
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].grid(True)
axs[0].set_xticks(x)
axs[0].set_xticklabels(xtickslabels[0])
axs[0].set_yticks(yticks[0])

# Box plot
# set all linewidth to 1
axs[1].boxplot(
    data,
    positions=positions,
    widths=5000,
    showfliers=False,
    boxprops=dict(color="darkgreen", linewidth=2),
    medianprops=dict(color="darkgreen", linewidth=2),
    whiskerprops=dict(color="darkgreen", linewidth=2),
    capprops=dict(color="darkgreen", linewidth=2),
)
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].yaxis.grid(True)
axs[1].set_xticks(positions)
axs[1].set_xticklabels(xtickslabels[1])
axs[1].set_yticks(yticks[1])

axs[1].scatter(positions, scatters_data, marker="^", color="darkgrey", s=100, zorder=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("multidiff_67.pdf", bbox_inches="tight")
