
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for bar plot
categories = ["Clinical", "Theoretical", "Applied"]
values = [0.4, 0.35, 0.25]

# Data for heatmap
data = np.array(
    [[0.6, 0.2, 0.4, 0.1], [0.2, 0.5, 0.3, 0.4], [0.3, 0.1, 0.6, 0.2]]
)
rows = ["Hypothesis 1", "Hypothesis 2", "Hypothesis 3"]
columns = ["Outcome A", "Outcome B", "Outcome C", "Outcome D"]
ylabel = "Article Proportion"
xlabel_bar = "Article Type"
ylabel_heatmap = "Study Outcomes"
title = "Distribution of Scientific Article Types"
supertitle = "Scientific Study Analysis"
color_bar = "#88CCEE"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(12, 5))
plt.suptitle(supertitle, fontsize=16)

# Create the bar plot on the left
plt.subplot(1, 2, 1)
bars = plt.bar(categories, values, color="#117733")
plt.ylabel(ylabel)
plt.xlabel(xlabel_bar)
plt.ylim([0, 0.5])
plt.title(title)

# Create the heatmap on the right
plt.subplot(1, 2, 2)
heatmap = plt.imshow(
    data, cmap="BuGn", interpolation="nearest", vmin=0, vmax=1.0
)
plt.xticks(np.arange(len(columns)), columns, rotation=30, ha="right")
plt.yticks(np.arange(len(rows)), rows)
plt.colorbar(heatmap)
plt.xlabel("Outcomes")
plt.ylabel(ylabel_heatmap)

# Annotate the heatmap with text
for i in range(len(rows)):
    for j in range(len(columns)):
        plt.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout(rect=[0, 0, 1, 0.96])

plt.savefig("multidiff_69.pdf", bbox_inches="tight")

