
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
import random
random.seed(42)

# Data for bar chart
categories = ["Wheat", "Corn", "Rice", "Barley"]
successful_harvests = [50, 75, 65, 45]

# Data for boxplot
yield_rates = [np.random.normal(0.65, 0.05, 100) for _ in categories]

# Thresholds for boxplot
yield_threshold_upper = 0.70
yield_threshold_lower = 0.55

# Labels and other text properties
ylabels = ["# of Successful\nHarvests", "Yield Rate"]
ax2hlineslabels = ["Upper Yield Threshold", "Lower Yield Threshold"]
ax2ylim = [0.50, 0.80]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots. ax1 and ax2 share the same x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(6, 6), sharex=True)

# Bar chart
ax1.bar(
    categories,
    successful_harvests,
    hatch="///",
    color="#8fbc8f",
    edgecolor="black",
    width=0.6,
)
ax1.set_ylabel(ylabels[0])

# Boxplot chart
ax2.boxplot(yield_rates, positions=range(len(categories)), widths=0.6)
ax2.hlines(
    yield_threshold_upper,
    xmin=-0.5,
    xmax=len(categories) - 0.5,
    colors="seagreen",
    linestyles="dashed",
    label=ax2hlineslabels[0],
)
ax2.hlines(
    yield_threshold_lower,
    xmin=-0.5,
    xmax=len(categories) - 0.5,
    colors="seagreen",
    linestyles="dashed",
    label=ax2hlineslabels[1],
)
ax2.fill_between(
    [-0.5, len(categories) - 0.5],
    yield_threshold_lower,
    yield_threshold_upper,
    color="lightgreen",
    alpha=0.15,
)
ax2.set_ylabel(ylabels[1])
ax2.yaxis.set_major_formatter(plt.FuncFormatter(lambda x, _: f"{x:.2f}"))
ax2.set_ylim(ax2ylim)
ax2.set_xticklabels(categories)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_72.pdf", bbox_inches="tight")
