
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents growth metrics in agriculture by year
years = ["2015", "2016", "2017", "2018", "2019", "2020"]
crop_yield = np.array([12, 18, 23, 28, 33, 40])
irrigation = np.array([6, 12, 18, 24, 30, 36])
fertilizer_use = np.array([3, 7, 12, 17, 23, 30])

# Cumulative data for the stacked Area chart
cumulative_crop_yield = crop_yield
cumulative_irrigation = cumulative_crop_yield + irrigation
cumulative_fertilizer_use = cumulative_irrigation + fertilizer_use

# Data for Bar Chart - Shows the number of publications by agricultural sub-domain
sub_domains = [
    "Crop Science",
    "Soil Science",
    "Agricultural Engineering",
    "Plant Pathology",
    "Entomology",
    "Agroecology",
    "Horticulture",
]
publications = [180, 120, 250, 90, 110, 130, 170]
titles = ["Growth Metrics in Agriculture Over Years", "Number of Publications by Agricultural Sub-Domain"]
xlabels = ["Year", "Sub-Domain"]
ylabels = ["Cumulative Metrics (%)", "Publications"]
ax1labels = ["Crop Yield", "Irrigation", "Fertilizer Use"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

# Plotting the Area Chart
ax1.fill_between(
    years, 0, cumulative_crop_yield, label=ax1labels[0], color="#3B9D3B", alpha=0.6
)
ax1.fill_between(
    years,
    cumulative_crop_yield,
    cumulative_irrigation,
    label=ax1labels[1],
    color="#A67C00",
    alpha=0.6,
)
ax1.fill_between(
    years,
    cumulative_irrigation,
    cumulative_fertilizer_use,
    label=ax1labels[2],
    color="#FFD700",
    alpha=0.6,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(sub_domains, publications, color="#6B8E23")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(sub_domains, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_74.pdf", bbox_inches="tight")
