
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents percentage increases in expertise by technology level
tech_levels = ["Intro", "Beginner", "Intermediate", "Advanced", "Expert", "Master"]
ai = np.array([5, 10, 20, 35, 50, 70])
big_data = np.array([10, 15, 25, 30, 45, 65])
cloud_computing = np.array([10, 20, 30, 40, 55, 75])

# Cumulative data for the stacked Area chart
cumulative_ai = ai
cumulative_big_data = cumulative_ai + big_data
cumulative_cloud_computing = cumulative_big_data + cloud_computing

# Data for Bar Chart - Shows the number of publications by technology field
tech_fields = [
    "AI",
    "Big Data",
    "Cloud Computing",
    "Cybersecurity",
    "IoT",
    "Blockchain",
    "Quantum Computing",
]
publications = [300, 250, 400, 220, 200, 180, 150]
titles = [
    "Expertise Increase by Technology Level",
    "Number of Publications by Technology Field",
]
xlabels = ["Technology Level", "Technology Field"]
ylabels = ["Cumulative Expertise (%)", "Publications"]
ax1labels = ["AI", "Big Data", "Cloud Computing"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plotting the Area Chart
ax1.fill_between(
    tech_levels, 0, cumulative_ai, label=ax1labels[0], color="#1f77b4", alpha=0.6
)
ax1.fill_between(
    tech_levels,
    cumulative_ai,
    cumulative_big_data,
    label=ax1labels[1],
    color="#ff7f0e",
    alpha=0.6,
)
ax1.fill_between(
    tech_levels,
    cumulative_big_data,
    cumulative_cloud_computing,
    label=ax1labels[2],
    color="#2ca02c",
    alpha=0.6,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(tech_fields, publications, color="#d62728")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(tech_fields, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_75.pdf", bbox_inches="tight")
