
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents population growth by age group over time
time_periods = ["2020", "2021", "2022", "2023", "2024", "2025"]
children = np.array([20, 21, 22, 23, 24, 25])
teens = np.array([15, 16, 17, 18, 19, 20])
adults = np.array([30, 32, 34, 36, 38, 40])
seniors = np.array([10, 11, 12, 13, 14, 15])

# Cumulative data for the stacked Area chart
cumulative_children = children
cumulative_teens = cumulative_children + teens
cumulative_adults = cumulative_teens + adults
cumulative_seniors = cumulative_adults + seniors

# Data for Bar Chart - Shows population distribution by region
regions = [
    "North",
    "South",
    "East",
    "West",
    "Central",
]
population_distribution = [150, 200, 180, 220, 170]
titles = ["Population Growth by Age Group", "Population Distribution by Region"]
xlabels = ["Year", "Region"]
ylabels = ["Cumulative Population (in thousands)", "Population (in thousands)"]
ax1labels = ["Children", "Teens", "Adults", "Seniors"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plotting the Area Chart
ax1.fill_between(
    time_periods, 0, cumulative_children, label=ax1labels[0], color="#1f77b4", alpha=0.7
)
ax1.fill_between(
    time_periods,
    cumulative_children,
    cumulative_teens,
    label=ax1labels[1],
    color="#ff7f0e",
    alpha=0.7,
)
ax1.fill_between(
    time_periods,
    cumulative_teens,
    cumulative_adults,
    label=ax1labels[2],
    color="#2ca02c",
    alpha=0.7,
)
ax1.fill_between(
    time_periods,
    cumulative_adults,
    cumulative_seniors,
    label=ax1labels[3],
    color="#d62728",
    alpha=0.7,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(regions, population_distribution, color="#9467bd")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(regions, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_76.pdf", bbox_inches="tight")
