
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Energy Consumption Data
countries = ["USA", "UK", "Germany", "France", "Italy", "Spain"]
energy_consumption = [5000, 3000, 4500, 3200, 2800, 2900]  # hypothetical values in kWh
consumption_error = [300, 200, 250, 220, 210, 200]  # standard error values

# Renewable Energy Usage Data
energy_types = ["Solar", "Wind", "Hydro", "Geothermal", "Biomass"]
usage_means = np.random.uniform(20, 80, len(energy_types))
usage_std_devs = np.random.uniform(5, 15, len(energy_types))
dataset_mean = np.mean(usage_means)

# Labels
titles = [
    "Average Energy Consumption by Country",
    "Renewable Energy Usage by Type"
]
ylabels = [
    "Energy Consumption (kWh per capita)",
    "Usage Percentage (%)"
]

ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes for the subplots
fig, axes = plt.subplots(2, 1, figsize=(10, 12))

# Energy Consumption Bar Plot
axes[0].bar(
    countries, energy_consumption, yerr=consumption_error, color="#87ceeb", capsize=5, ecolor="black"
)
axes[0].set_title(titles[0])
axes[0].set_ylabel(ylabels[0])
axes[0].grid(True)

# Renewable Energy Usage Error Point Plot
axes[1].errorbar(
    energy_types,
    usage_means,
    yerr=usage_std_devs,
    fmt="o",
    color="#32cd32",
    ecolor="#32cd32",
    capsize=5,
    ms=10,
)
axes[1].axhline(y=dataset_mean, color="grey", linestyle="--")
axes[1].set_title(titles[1])
axes[1].set_ylabel(ylabels[1])
axes[1].set_ylim(ylim)
axes[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to avoid overlap and save the figure
plt.tight_layout()
plt.savefig("multidiff_81.pdf", bbox_inches="tight")

