
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# ========== Bar with Error Data (Literature Research Success Rates) ==========
# Research Methods
research_methods = ["Survey", "Interview", "Textual Analysis", "Focus Group"]
# Success rates
success_rates = [82, 90, 78, 85]
# Error margins
errors = [3, 5, 7, 4]

# ========== Scatter with Error Data (Annotation Tool Efficiency) ==========
# Annotation Tools
annotation_tools = ["Tool A", "Tool B", "Tool C", "Tool D"]
# Efficiency scores
efficiency = np.random.uniform(60, 90, len(annotation_tools))
# Standard deviations
std_devs = np.random.uniform(4, 8, len(annotation_tools))

# ========== Line with Error Data (Literary Theory Adaptability) ==========
# Theories
theories = ["Theory 1", "Theory 2", "Theory 3", "Theory 4"]
# Adaptability scores
adaptability_classical = np.random.uniform(70, 85, len(theories))
adaptability_modern = np.random.uniform(60, 80, len(theories))
# Error
error = np.random.uniform(2, 3, len(theories))

# Titles and Labels
titles = [
    "Literature Research Success Rates",
    "Annotation Tool Efficiency Scores",
    "Literary Theory Adaptability",
]
ylabels = ["Success Rate (%)", "Efficiency (%)", "Adaptability Score (%)"]
ax2ylim = [50, 100]
ax3labels = ["Classical Context", "Modern Context"]

legend_title = "Contexts"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and grid layout
fig = plt.figure(figsize=(10, 10))
gs = GridSpec(2, 2, figure=fig)

# Bar with Error Plot
ax1 = fig.add_subplot(gs[0, :])
ax1.bar(research_methods, success_rates, yerr=errors, color="#d4a373", capsize=5, ecolor="darkred")
ax1.set_title(titles[0])
ax1.set_ylabel(ylabels[0])
ax1.grid(True)

# Scatter with Error Plot
ax2 = fig.add_subplot(gs[1, 0])
ax2.errorbar(
    annotation_tools,
    efficiency,
    yerr=std_devs,
    fmt="o",
    color="#81b29a",
    ecolor="darkred",
    capsize=5,
    ms=10,
)
ax2.set_title(titles[1])
ax2.set_ylabel(ylabels[1])
ax2.set_ylim(ax2ylim)
ax2.grid(True)

# Line with Error Plot
ax3 = fig.add_subplot(gs[1, 1])
ax3.errorbar(
    theories,
    adaptability_classical,
    yerr=error,
    fmt="o-",
    color="brown",
    ecolor="darkred",
    capsize=5,
    label=ax3labels[0]
)
ax3.errorbar(
    theories,
    adaptability_modern,
    yerr=error,
    fmt="s-",
    color="teal",
    ecolor="darkred",
    capsize=5,
    label=ax3labels[1]
)
ax3.set_title(titles[2])
ax3.set_ylabel(ylabels[2])
ax3.legend(title=legend_title)
ax3.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_91.pdf", bbox_inches="tight")
