
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Artistic Media Usage -------
categories = ["Digital Art", "Traditional Painting", "Sculpture", "Photography", "Ceramics"]
sizes = [35, 25, 15, 15, 10]  # Percentages of each medium

explode = (0.1, 0, 0, 0, 0)  # Highlight Digital Art

# ------- Radar Chart Data for Skills Developed in Artistic Media -------
labels = np.array(["Creativity", "Technical Precision", "Artistic Expression", "Attention to Detail", "Originality"])
num_vars = len(labels)
values = np.array([0.95, 0.85, 0.80, 0.75, 0.90])
values = np.concatenate((values, [values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Artistic Media Usage"
title_2 = "Skills Developed in Artistic Media"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff6666", "#66ccff", "#ffcc66", "#99ff99", "#c266ff"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
)
ax1.set_title(title_1)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, values, color="#1f77b4", alpha=0.25)
ax2.plot(angles, values, color="#1f77b4", linewidth=1.5, linestyle='-', marker='o')

ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(labels)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_96.pdf", bbox_inches="tight")
