
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Philosophy Education Programs -------
categories = [
    "Ethics",
    "Metaphysics",
    "Logic",
    "Epistemology",
    "Aesthetics",
]
sizes = [25, 20, 30, 15, 10]  # Percentages of each program

explode = (0.1, 0, 0.1, 0, 0)  # Highlight Ethics and Logic

# ------- Radar Chart Data for Student Performance in Philosophy Education -------
labels = np.array(
    ["Critical Thinking", "Argumentation", "Analytical Skills", "Creativity", "Collaboration"]
)
num_vars = len(labels)
values = np.array([0.85, 0.75, 0.80, 0.70, 0.65])
values = np.concatenate((values, [values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Philosophy Education Programs"
title_2 = "Student Performance in Philosophy Education"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b", "#1f77b4", "#aec7e8", "#ff7f0e", "#2ca02c"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
    shadow=True,
)
ax1.set_title(title_1, fontsize=14)
ax1.axis("equal")

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, values, color="purple", alpha=0.25)
ax2.plot(angles, values, color="purple", linewidth=2, linestyle="dashed")
ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(labels, fontsize=10)
ax2.set_title(title_2, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_97.pdf", bbox_inches="tight")
