
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Placing import in Part 2 as per requirement
np.random.seed(42)

# New Data for Picture in Picture bar plot
tech_sales_known = np.array(
    [18000, 16000, 14000, 12000, 10000, 8000, 6000, 5000, 4000, 2000, 1000]
)
tech_sales_unknown = np.array(
    [12000, 10000, 8000, 7000, 6000, 5000, 4000, 3000, 2000, 1000, 500]
)
bins = np.linspace(0, 0.5, 11)

# New Data for the heatmap
tech_ratings = np.array(
    [
        [95, 85, 75, 65, 60, 55],
        [92, 80, 70, 68, 54, 45],
        [90, 78, 68, 62, 49, 38],
        [88, 76, 66, 60, 50, 40],
        [85, 75, 65, 55, 45, 35],
    ]
)
x_labels = [
    "Gadget A",
    "Gadget B",
    "Gadget C",
    "Gadget D",
    "Gadget E",
    "Gadget F",
]
y_labels = ["North", "South", "East", "West", "Central"]
bar_labels = ["Known Tech Sales", "Unknown Tech Sales"]
xlabels = ["Market Share", "Tech Gadgets"]
ylabels = ["Sales Volume", "Regions"]
cbarlabel = "User Satisfaction"
insetaxes = [0.261, 0.5, 0.1, 0.2]
insetxlim = [0.25, 0.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with GridSpec
fig = plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1.5])

# Picture in Picture bar plot
ax0 = plt.subplot(gs[0])
ax0.bar(
    bins,
    tech_sales_known,
    width=0.04,
    color="#ffb6c1",
    align="center",
    label=bar_labels[0],
    edgecolor="black",
)
ax0.bar(
    bins,
    tech_sales_unknown,
    width=0.04,
    color="#87cefa",
    align="center",
    bottom=tech_sales_known,
    label=bar_labels[1],
    edgecolor="black",
)
ax0.set_xlabel(xlabels[0])
ax0.set_ylabel(ylabels[0])
ax0.legend(loc="upper right")
ax0.grid(True)

# Add inset
ax_inset = fig.add_axes(insetaxes)
ax_inset.bar(
    bins[5:],
    tech_sales_known[5:],
    width=0.04,
    color="#ffb6c1",
    align="center",
    edgecolor="black",
)
ax_inset.bar(
    bins[5:],
    tech_sales_unknown[5:],
    width=0.04,
    color="#87cefa",
    align="center",
    bottom=tech_sales_known[5:],
    edgecolor="black",
)
ax_inset.set_xlim(insetxlim)

# Heatmap plot
ax1 = plt.subplot(gs[1])
cmap = plt.cm.viridis
norm = plt.Normalize(vmin=tech_ratings.min(), vmax=tech_ratings.max())
heatmap = ax1.imshow(tech_ratings, cmap=cmap, norm=norm, aspect="auto")

# Add color bar
cbar = plt.colorbar(heatmap, ax=ax1, orientation="vertical", pad=0.1)
cbar.set_label(cbarlabel)

# Set x and y labels
ax1.set_xticks(np.arange(len(x_labels)))
ax1.set_yticks(np.arange(len(y_labels)))
ax1.set_xticklabels(x_labels, rotation=45)
ax1.set_yticklabels(y_labels)
ax1.set_xlabel(xlabels[1])
ax1.set_ylabel(ylabels[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_99.pdf", bbox_inches="tight")
