
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Historical periods for the outer ring
outer_labels = ["Roman Empire", "Ancient Egypt", "Ancient China", "Ancient Greece"]
outer_sizes = [35, 25, 20, 20]  # Relative prominence sizes

# Notable periods within the Roman Empire for the inner ring
inner_labels = ["Republic Period", "Imperial Period", "Late Antiquity", "Byzantine Period"]
inner_sizes = [20, 40, 20, 20]  # Period sizes within Roman Empire

# Chart labels
title = "Historical Eras and Prominent Periods"
suptitle = "Ancient Civilizations and Periods within the Roman Empire"
legendlabels = outer_labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))
# Appropriate historical color palette
outer_colors = ["#d9bf77", "#e79962", "#9c755f", "#4b8d8f"]
inner_colors = ["#f0e4d7", "#e0bb95", "#b8a892", "#8f6c5d"]

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=outer_labels,
    radius=1.2,
    colors=outer_colors,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Adding a title and supertitle
plt.title(title, fontsize=16)
plt.suptitle(suptitle, fontsize=12)

# Adding a legend with outer labels
ax.legend(wedges, legendlabels, loc="center left", bbox_to_anchor=(1, 0.5))

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_24.pdf", bbox_inches="tight")
