
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Box Office 40%", "Streaming 25%", "Merchandise 20%", "Other 15%"]
title = "Revenue Distribution in Entertainment Industry"
supertitle = "Revenue Streams for 2023"

outer_sizes = [40, 25, 20, 15]  # different revenue streams percentages
inner_sizes = [15, 10, 8, 7]    # sub-division within revenue streams

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

outer_colors = ["#ffcccb", "#add8e6", "#90ee90", "#ffb6c1"]
inner_colors = ["#ffd700", "#ff6347", "#4682b4", "#9acd32"]


# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
    wedgeprops=dict(width=0.3, edgecolor='w')
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.9,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
    wedgeprops=dict(width=0.3, edgecolor='w')
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title, labels, and legend
plt.suptitle(supertitle, fontsize=16, fontweight='bold')
plt.title(title, fontsize=12)
plt.legend(wedges, labels, title="Revenue Streams", loc="center left", bbox_to_anchor=(1, 0, 0.5, 1))

# ===================
# Part 4: Saving Output
# ===================
# Minimize white space and save the plot
plt.tight_layout()
plt.savefig("pie_25.pdf", bbox_inches="tight")
