
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Labels and sizes for political parties
labels = ["Party A", "Party B", "Party C", "Party D"]
sizes = [120, 90, 60, 30]
legend_labels = labels

# Chart title and other text labels
chart_title = "Legislative Assembly Seat Distribution"
legend_loc = "upper center"
legend_ncol = 4
legend_frameon = False
legend_bbox_to_anchor = (0.5, 1.20)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))
# Custom color palette for political parties
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

ax.pie(sizes, colors=colors, autopct="%1.1f%%", startangle=140)
plt.title(chart_title, fontsize=14)
plt.legend(
    legend_labels,
    loc=legend_loc,
    ncol=legend_ncol,
    frameon=legend_frameon,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_27.pdf", bbox_inches="tight")
