
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Spain 30%", "Italy 25%", "France 35%", "Greece 10%"]
sizes = [30, 25, 35, 10]

title = "Tourist Distribution in Europe"
output_filename = 'pie_4_0.pdf'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(5, 5))
colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99']  # vibrant colors suitable for tourism
ax.pie(sizes, labels=labels, colors=colors, hatch=['//', '\\\\', '||', '++'], startangle=140)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_30.pdf", bbox_inches="tight")
