
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the pie chart
labels = ["Apple 30%", "Microsoft 25%", "Google 20%", "Amazon 15%", "Facebook 10%"]
sizes = [30, 25, 20, 15, 10]

# Additional text labels
title = "Market Share of Tech Companies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a custom color palette
colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99','#c2c2f0']

# Create the pie chart
fig, ax = plt.subplots(figsize=(7, 7))
ax.pie(sizes, labels=labels, colors=colors, autopct='%1.1f%%', startangle=140, 
       wedgeprops={'linewidth': 1, 'edgecolor': 'black'})

# Title configuration
plt.title(title, fontsize=16, weight='bold')

# Additional adjustments
plt.tight_layout()
plt.axis('equal')  # Equal aspect ratio ensures the pie chart is circular

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("pie_32.pdf", bbox_inches="tight")

