
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data to plot
sizes = [20, 15, 25, 10, 18, 12]
labels = ['Wheat', 'Corn', 'Rice', 'Barley', 'Soybean', 'Oats']
title = "Agricultural Crop Production Distribution"
suptitle = 'Crop Production - 2023'
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(7, 7))
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
colors = ['#8FBC8F', '#556B2F', '#6B8E23', '#2E8B57', '#3CB371', '#228B22']
ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Set aspect ratio to be equal so that pie is drawn as a circle.
ax.axis("equal")

plt.title(title, fontsize=16)
plt.suptitle(suptitle, fontsize=20)

# Adding a legend outside the pie chart
plt.legend(labels, loc="center left", bbox_to_anchor=(1, 0.5))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_33.pdf", bbox_inches="tight")
