
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data to plot
sizes = [25, 15, 20, 10, 18, 12]
labels = ['Technology', 'Healthcare', 'Financials', 'Consumer Discretionary', 'Energy', 'Utilities']

title = "Market Share by Sector in Financial Market"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(7, 7))
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
explode = (0.05, 0.05, 0.05, 0.05, 0.05, 0.05)  # Slightly explode all slices
# Create the pie chart
ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="gray"),
    explode=explode,
)

# Set aspect ratio to be equal so that pie is drawn as a circle.
ax.axis("equal")

plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_34.pdf", bbox_inches="tight")
