
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing necessary library for data processing

np.random.seed(0)

# Data to plot
sizes = [15, 25, 20, 10, 18, 12]  # Types of cases: Criminal, Civil, Family, Corporate, IP, Labor
labels = ["Criminal", "Civil", "Family", "Corporate", "IP", "Labor"]
title = "Distribution of Cases Handled by the Law Firm"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(7, 7))  # Adjusted figsize for better visualization
colors = plt.cm.Blues(np.linspace(0.3, 0.7, len(sizes)))  # Use a professional colormap
explode = (0.1,) * len(sizes)  # Separate all slices equally
ax.pie(
    sizes,
    colors=colors,
    labels=labels,  # Added labels to slices
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Set aspect ratio to be equal so that pie is drawn as a circle.
ax.axis("equal")

plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_35.pdf", bbox_inches="tight")
