
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data to plot
labels = ["Conservative", "Liberal", "Green", "Libertarian", "Others"]
sizes = [30, 40, 15, 10, 5]

# Text labels and other parameters
title = "Political Party Support Distribution"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 6))
explode = (0.1, 0.1, 0, 0, 0)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
legend_labels = labels

plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
)
plt.axis("equal")

# Add legend
plt.legend(legend_labels, loc="upper left")
plt.title(title, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_39.pdf", bbox_inches="tight")
