
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Data to plot
labels = ["WWDC", "Google I/O", "Microsoft Build", "CES", "SXSW"]
sizes = [30.0, 25.0, 20.0, 15.0, 10.0]
title = "Tech Conference Influence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot setup
fig, ax = plt.subplots(figsize=(8, 8))
colors = plt.cm.tab20c(np.linspace(0, 1, len(sizes)))
explode = (0.1, 0, 0.1, 0, 0)  # Explode the 1st and 3rd slices

wedges, texts, autotexts = ax.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
)

# Adding annotations
bbox_props = dict(boxstyle="round,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="-"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = "angle,angleA=0,angleB={}".format(ang)
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        labels[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.2 * y),
        horizontalalignment=horizontalalignment,
        **kw
    )

# Title and equal axis
ax.set_title(title, fontsize=17, x=0.5, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("pie_44.pdf", bbox_inches="tight")
