
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Labels for education levels
labels = ["Primary", "Secondary", "Tertiary", "Post-Graduate", "Other"]
# Distribution of education levels in the national population
outer_sizes = [300, 400, 200, 100, 50]  
# Distribution of education levels in a specific university
inner_sizes = [30, 120, 250, 100, 0]

# Text label parameters
title = "Education Levels - National vs. University"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7))

# New color schemes reflecting education domain
outer_colors = ["#1f77b4", "#aec7e8", "#ffbb78", "#98df8a", "#c5b0d5"]
inner_colors = ["#2ca02c", "#ff9896", "#9467bd", "#d62728", "#8c564b"]

explode_outer = (0.1, 0, 0, 0, 0)  # only explode the 1st slice (Primary)

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the double layer pie chart
ax.set_title(title, fontsize=20, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_45.pdf", bbox_inches="tight")

