
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
agriculture_products = [
    "400 kg Wheat",
    "300 kg Corn",
    "250 kg Rice",
    "150 kg Soybeans",
    "100 kg Barley",
    "50 kg Oats",
]

data = [400, 300, 250, 150, 100, 50]
title = "Agriculture Product Distribution: A Donut"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(aspect="equal"))
colors = plt.cm.Paired(np.linspace(0, 1, len(data)))
wedges, texts = ax.pie(data, wedgeprops=dict(width=0.5, edgecolor='w'), startangle=-40, colors=colors, shadow=True)

bbox_props = dict(boxstyle="square,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="->"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = f"angle,angleA=0,angleB={ang}"
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        agriculture_products[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.4 * y),
        horizontalalignment=horizontalalignment,
        **kw,
    )

ax.set_title(title, fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_48.pdf", bbox_inches="tight")
